﻿using System;
using System.Web;
using System.Web.Services;
using BusinessEntities;
using EntityServices;
using System.Web.Services.Protocols;

[WebService(Namespace = "http://contoso.com/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class CustomerProfile : System.Web.Services.WebService
{
  
  EntityServices.CustomerProfile _custProfile =
    new EntityServices.CustomerProfile();

  public CustomerProfile()
  {
  }

  [WebMethod(Description = "Zwraca profil klienta.")]
  public Customer GetCustomer(string customerId)
  {
    Customer cust = _custProfile.GetCustomer(customerId);
    if (cust == null) 
    {
      SoapException soapEx = new SoapException("Nie można znaleźć klienta.",
        SoapException.ClientFaultCode, Context.Request.Url.AbsoluteUri.ToString());
      throw soapEx;
    }
    return cust;
  }

  [WebMethod(Description = "Zwraca dane wszystkich aktywnych klientów.")]
  public System.Data.DataSet GetActiveCustomers()
  {
    return _custProfile.GetActiveCustomers();
  }

  [WebMethod(Description = "Tworzy nowy rekord klienta.")]
  public void CreateCustomer(Customer customer)
  {
    _custProfile.SaveCustomer(customer, true);
  }

  [WebMethod(Description = "Aktualizuje rekord klienta.")]
  public void UpdateCustomer(Customer customer)
  {
    _custProfile.SaveCustomer(customer, false);
  }

  [WebMethod(Description = "Usuwa dane klienta.")]
  public void DeleteCustomer(string customerId)
  {
    _custProfile.DeleteCustomer(customerId);
  }
}


// Aby umożliwić wywoływanie usługi sieciowej w skrypcie za pomocą technologii  
// ASP.NET AJAX, należy usunąć symbole komentarza z poniższego wiersza. 
// [System.Web.Script.Services.ScriptService]
